#include <cstdio>
#include <cassert>
#include <cstring>
#include <algorithm>
#include <iostream>
#include <ctime>
#include <unistd.h>
#include <vector>
#include <set>
#include <queue>
#include <string>

using namespace std;

#define FOR(i, a, b) for (int i=(a); i<(b); i++)
#define REP(i, n) FOR(i, 0, n)
#define X first
#define Y second

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long ll;
typedef pair<int, int> P;

const int MAX = 6e5 + 100; //3*N

P pref[MAX], suf[MAX];
P x[MAX], y[MAX]; //[, ]
vector <int> SorX;
int n, M;

void sazmi(P p[], vector <int> &V) {
  V = {-1, -2, 0, M, M+1, M+2};
  
  REP(i, n) {
    V.push_back(p[i].X);
    V.push_back(p[i].Y);
    V.push_back(p[i].Y+1);
  }
  sort(V.begin(), V.end());
  V.resize(unique(V.begin(), V.end()) - V.begin());
  
  REP(i, n) {
    p[i].X = (int) (lower_bound(V.begin(),V.end(), p[i].X) - V.begin());
    p[i].Y = (int) (lower_bound(V.begin(),V.end(), p[i].Y) - V.begin());
  }  
}

P presjeci(P a, P b) {
  return P(max(a.X, b.X), min(a.Y, b.Y));
}

void calc_prefix() { //presjek onih sa x.Y < i
  REP(i, MAX) pref[i] = P(0, M+1);
  
  REP(i, n)
    pref[x[i].Y+1] = presjeci(pref[x[i].Y+1], y[i]);

  FOR(i, 1, MAX)
    pref[i] = presjeci(pref[i], pref[i-1]);
}

void calc_sufix() { //presjek onih sa x.X > i
  REP(i, MAX) suf[i] = P(0, M+1);

  REP(i, n) {
    assert(x[i].X);
    suf[x[i].X-1] = presjeci(suf[x[i].X-1], y[i]);
  }

  for (int i=MAX-2; i>=0; i--)
    suf[i] = presjeci(suf[i+1], suf[i]);
}

ll sweep() {
  ll ret=0;
  
  REP(i, (int) SorX.size()-1) {
    if (SorX[i] >= 0 && SorX[i+1] <= M+1) {
      P presjek = presjeci(pref[i], suf[i]);      
      ret += max(0, presjek.Y - presjek.X) * (ll)(SorX[i+1] - SorX[i]);
    }
  }

  return ret;
}

int main() {
  scanf("%d%d", &n, &M);

  REP(i, n) {
    scanf("%d%d%d%d", &x[i].X, &x[i].Y, &y[i].X, &y[i].Y);
    y[i].Y++;
  }

  sazmi(x, SorX);

  calc_prefix();
  calc_sufix();

  printf("%lld\n", sweep());  

  return 0;
}
